/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.config.io;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.enums.RegionSize;
import com.yungnickyoung.minecraft.bettercaves.noise.FastNoise;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TreeMap;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.io.IOUtils;

public class ConfigLoader {
    private static final String ALLOWED_CHARS = "._-";
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static ConfigHolder loadConfigFromFileForDimension(int dimensionID) {
        String fileName = "DIM" + dimensionID + "_config.cfg";
        File configFile = new File(BetterCaves.customConfigDir, fileName);
        if (!configFile.exists() || configFile.isDirectory()) {
            BetterCaves.LOGGER.info(String.format("Better Caves config file for dimension %d not found. Using global config...", dimensionID));
            return new ConfigHolder();
        }
        if (!configFile.canRead()) {
            BetterCaves.LOGGER.warn(String.format("Better Caves config file for dimension %d not readable. Using global config...", dimensionID));
            return new ConfigHolder();
        }
        BetterCaves.LOGGER.info(String.format("Reading Better Caves config from file for dimension %d...", dimensionID));
        return ConfigLoader.parseConfigFromFile(configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigHolder parseConfigFromFile(File file) {
        ConfigHolder config = new ConfigHolder();
        BufferedReader buffer = null;
        Configuration.UnicodeInputStreamReader input = null;
        String fileName = file.getName();
        try {
            TreeMap<String, ConfigCategory> categories = new TreeMap<String, ConfigCategory>();
            input = new Configuration.UnicodeInputStreamReader((InputStream)new FileInputStream(file), DEFAULT_ENCODING);
            buffer = new BufferedReader((Reader)input);
            ConfigCategory currCategory = null;
            Property.Type type = null;
            ArrayList<String> tmpList = null;
            int lineNum = 0;
            String name = null;
            while (true) {
                ++lineNum;
                String line = buffer.readLine();
                if (line == null) break;
                int nameStart = -1;
                int nameEnd = -1;
                boolean skip = false;
                boolean quoted = false;
                boolean isTypeSpecified = false;
                boolean isFirstNonWhitespaceCharOnLine = true;
                block21: for (int i = 0; i < line.length() && !skip; ++i) {
                    if (Character.isLetterOrDigit(line.charAt(i)) || ALLOWED_CHARS.indexOf(line.charAt(i)) != -1 || quoted && line.charAt(i) != '\"') {
                        if (nameStart == -1) {
                            nameStart = i;
                        }
                        nameEnd = i;
                        isFirstNonWhitespaceCharOnLine = false;
                        continue;
                    }
                    if (Character.isWhitespace(line.charAt(i))) continue;
                    switch (line.charAt(i)) {
                        case '#': {
                            if (tmpList != null) break;
                            skip = true;
                            continue block21;
                        }
                        case '\"': {
                            if (tmpList != null) break;
                            if (quoted) {
                                quoted = false;
                            }
                            if (quoted || nameStart != -1) break;
                            quoted = true;
                            break;
                        }
                        case '{': {
                            if (tmpList != null) break;
                            name = line.substring(nameStart, nameEnd + 1);
                            String qualifiedName = ConfigCategory.getQualifiedName((String)(name = name.toLowerCase(Locale.ENGLISH)), (ConfigCategory)currCategory);
                            ConfigCategory category = (ConfigCategory)categories.get(qualifiedName);
                            if (category == null) {
                                currCategory = new ConfigCategory(name, currCategory);
                                categories.put(qualifiedName, currCategory);
                            } else {
                                currCategory = category;
                            }
                            name = null;
                            break;
                        }
                        case '}': {
                            if (tmpList != null) break;
                            if (currCategory == null) {
                                throw new RuntimeException(String.format("Invalid config file: attempted to close too many categories '%s:%d'", fileName, lineNum));
                            }
                            currCategory = currCategory.parent;
                            break;
                        }
                        case '=': {
                            if (tmpList != null) break;
                            name = line.substring(nameStart, nameEnd + 1);
                            if (currCategory == null) {
                                throw new RuntimeException(String.format("'%s' has no scope (missing category?) in '%s:%d'", name, fileName, lineNum));
                            }
                            if (!isTypeSpecified) {
                                BetterCaves.LOGGER.warn(String.format("Error in Better Caves config for %s (line %d): missing variable type specifier. Inferring String...", fileName, lineNum));
                            }
                            Property prop = new Property(name, line.substring(i + 1), type, true);
                            String fullName = currCategory.getQualifiedName() + "." + name;
                            ConfigHolder.ConfigOption<?> target = config.properties.get(fullName);
                            if (target != null) {
                                switch (type) {
                                    case INTEGER: {
                                        if (!target.type.equals(Integer.TYPE) && !target.type.equals(Integer.class)) {
                                            BetterCaves.LOGGER.error(String.format("ERROR: WRONG TYPE for %s in config %s. Skipping...", fullName, fileName));
                                            i = line.length();
                                            continue block21;
                                        }
                                        target.set(prop.getInt());
                                        break;
                                    }
                                    case DOUBLE: {
                                        if (!(target.type.equals(Double.TYPE) || target.type.equals(Double.class) || target.type.equals(Float.TYPE) || target.type.equals(Float.class))) {
                                            BetterCaves.LOGGER.error(String.format("ERROR: WRONG TYPE for %s in config %s. Skipping...", fullName, fileName));
                                            i = line.length();
                                            continue block21;
                                        }
                                        if (target.type == Float.class) {
                                            target.set(Float.valueOf((float)prop.getDouble()));
                                            break;
                                        }
                                        target.set(prop.getDouble());
                                        break;
                                    }
                                    case BOOLEAN: {
                                        if (!target.type.equals(Boolean.TYPE) && !target.type.equals(Boolean.class)) {
                                            BetterCaves.LOGGER.error(String.format("ERROR: WRONG TYPE for %s in config %s. Skipping...", fullName, fileName));
                                            i = line.length();
                                            continue block21;
                                        }
                                        if (!line.substring(i + 1).toLowerCase().equals("true") && !line.substring(i + 1).toLowerCase().equals("false")) {
                                            throw new RuntimeException(String.format("Invalid Boolean value for property '%s:%d'", fullName, lineNum));
                                        }
                                        target.set(prop.getBoolean());
                                        break;
                                    }
                                    default: {
                                        if (!(target.type.equals(String.class) || target.type.equals(RegionSize.class) || target.type.equals(FastNoise.NoiseType.class))) {
                                            BetterCaves.LOGGER.error(String.format("ERROR: WRONG TYPE for %s in config %s. Skipping...", fullName, fileName));
                                            i = line.length();
                                            continue block21;
                                        }
                                        if (target.type == RegionSize.class) {
                                            target.set((Object)RegionSize.valueOf(prop.getString()));
                                            break;
                                        }
                                        if (target.type == FastNoise.NoiseType.class) {
                                            target.set((Object)FastNoise.NoiseType.valueOf(prop.getString()));
                                            break;
                                        }
                                        target.set(prop.getString());
                                    }
                                }
                            } else {
                                BetterCaves.LOGGER.error(String.format("ERROR: INVALID PROPERTY %s in config %s. Skipping...", fullName, fileName));
                                i = line.length();
                                continue block21;
                            }
                            currCategory.put(name, prop);
                            BetterCaves.LOGGER.debug(String.format("%s: overriding config option: %s", fileName, fullName));
                            i = line.length();
                            break;
                        }
                        case ':': {
                            if (tmpList != null) break;
                            String typeSubstr = line.substring(nameStart, nameEnd + 1);
                            type = Property.Type.tryParse((char)typeSubstr.charAt(0));
                            nameEnd = -1;
                            nameStart = -1;
                            isTypeSpecified = true;
                            break;
                        }
                        case '<': {
                            if (tmpList != null && i + 1 == line.length() || tmpList == null && i + 1 != line.length()) {
                                throw new RuntimeException(String.format("Malformed list property \"%s:%d\"", fileName, lineNum));
                            }
                            if (i + 1 != line.length()) break;
                            name = line.substring(nameStart, nameEnd + 1);
                            if (currCategory == null) {
                                throw new RuntimeException(String.format("'%s' has no scope (missing category?) in '%s:%d'", name, fileName, lineNum));
                            }
                            tmpList = new ArrayList<String>();
                            skip = true;
                            break;
                        }
                        case '>': {
                            if (tmpList == null) {
                                throw new RuntimeException(String.format("Malformed list property \"%s:%d\"", fileName, lineNum));
                            }
                            if (!isFirstNonWhitespaceCharOnLine) break;
                            currCategory.put(name, new Property(name, tmpList.toArray(new String[0]), type));
                            name = null;
                            tmpList = null;
                            type = null;
                            break;
                        }
                        case '~': {
                            if (tmpList == null) break;
                            break;
                        }
                        default: {
                            if (tmpList != null) break;
                            throw new RuntimeException(String.format("Unknown character '%s' in '%s:%d'", Character.valueOf(line.charAt(i)), fileName, lineNum));
                        }
                    }
                    isFirstNonWhitespaceCharOnLine = false;
                }
                if (quoted) {
                    throw new RuntimeException(String.format("Unmatched quote in '%s:%d'", fileName, lineNum));
                }
                if (tmpList == null || skip) continue;
                tmpList.add(line.trim());
            }
        }
        catch (Exception e) {
            ConfigHolder configHolder;
            try {
                BetterCaves.LOGGER.error(String.format("ERROR LOADING BETTER CAVES CONFIG %s: %s.", fileName, e.toString()));
                BetterCaves.LOGGER.info("USING GLOBAL CONFIG FILE INSTEAD...");
                configHolder = new ConfigHolder();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(buffer);
                IOUtils.closeQuietly(input);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)buffer);
            IOUtils.closeQuietly((Reader)input);
            return configHolder;
        }
        IOUtils.closeQuietly((Reader)buffer);
        IOUtils.closeQuietly((Reader)input);
        return config;
    }
}

